/**
* \file: automounter_types_internal.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AMS_AUTOMOUNTER_TYPES_H
#define AMS_AUTOMOUNTER_TYPES_H

#include "automounter_types.h"

//--- This file is needed to overcome the limits of structured make files, sorry ------------------------------------

typedef enum message_type_t
{
	__NO_MSG=0,
	SET_APPINFO_MSG,
	GET_SNAPSHOT_MSG,
	SNAPSHOT_COMPLETE_MSG,
	DEVICE_STATE_CHANGED_MSG,
	PARTITION_STATE_CHANGED_MSG,
	UMOUNT_REQUEST_MSG,
	REMOUNT_REQUEST_MSG,
	REQUEST_DONE_MSG,
	__LAST_MSG_MARKER
} message_type_t;

const char *automounter_get_device_state_string(device_state_t state);

const char *automounter_get_partition_state_string(partition_state_t state);

const char *automounter_get_unsupported_reason_string(partition_unsupported_reason_t state);

#endif
